
	/* *****************
	*   Functions
	*  *****************/
	function EvaluateKey(e)
	{
		var x = e.keyCode;
		if(x == 13)
			ClosePwdModal();
	}
	
	function ShowModalAlert(alertmsg)
	{
		document.getElementById('lblAlert').textContent = alertmsg;
		modalAlert.style.display='block';
	}
	function CloseAlertModal()
	{
	    modalAlert.style.display='none';
	}
	//**************************************************************************************
	//Request password popup management
	function ShowPwdModal()
	{
		document.getElementById('lblPwdInfoUser').value = "User";
		document.getElementById('lblPwdInfoPassword').value = "Password";
		modal.style.display='block';
	}

	function CancelPwdModal()
	{
	    modal.style.display='none';
	}
	function ClosePwdModal()
	{
	    modal.style.display='none';
	    var username = document.getElementById('pwdUser').value;
	    var Authpassword = document.getElementById('pwdPassword').value;
	    var msg = PrepareAuthentication(username, Authpassword);
	    ws.send(msg);
	    questionSent = true;
	}
	// END Request password popup management
	//**************************************************************************************
	
	//**************************************************************************************
	//Request input value popup management
	function ShowInputValue(oldVal, minVal, maxVal, varName)
	{
		var mytitle = "Please, enter the value";
		if(minVal.length > 0) 
		{
			mytitle = mytitle + " (range " + minVal + "-" + maxVal + ")";
		}
		if(varName.length > 0)
		{
			mytitle = mytitle + " " + varName;
		}
	    document.getElementById('lblInfo').textContent = mytitle;
	    document.getElementById('newVal').value = oldVal;
	    modalpop.style.display='block';
	}
	function CancelInputModal()
	{
	    modalpop.style.display='none';
	}
	function CloseInputModal()
	{
	    modalpop.style.display='none';
	    var newVal = document.getElementById('newVal').value;
	    var msg = PrepareNewValue(newVal);
	    ws.send(msg);
	    questionSent = true;
	}
	// END Request input value popup management
	//**************************************************************************************
	
	//**************************************************************************************
	//Windows lifetime
	var currentWindowWidth = 0;
	var currentWindowHeight = 0;
	var OriginalWindowWidth = 0;
	var OriginalWindowHeight = 0;
	
	var WinDevPixRatio = 1;
	var bIsMobile = false;
	
	var inOffsett = 30;
	
	//Called in window.onload
	function init() {

		var nAg = navigator.userAgent;
		if(nAg.indexOf("Android") != -1 || nAg.indexOf("webOS") != -1 ||
			nAg.indexOf("iPhone") != -1 || nAg.indexOf("iPad") != -1 || nAg.indexOf("iPod") != -1 || 
			nAg.indexOf("BlackBerry") != -1 || nAg.indexOf("IEMobile") != -1 || nAg.indexOf("Opera Mini") != -1)
			bIsMobile = true;

		if(!showBar)
		{
			var bar = document.getElementById('myBar');
			bar.style.display = 'none';
			inOffsett = 0;
		}
		
		WinDevPixRatio = window.devicePixelRatio;
		if(!bIsMobile)
			window.addEventListener("resize", OnWindowResize, true);
		resizeCanvas();
		
		canvasMain.addEventListener("mousedown", oncanvasMainMouseDown, false);
		canvasMain.addEventListener("mouseup", oncanvasMainMouseUp, false);
		canvasMain.addEventListener("mousemove", oncanvasMainMouseMove, false);

		
		openConnection();
		
	}
	
		
	//called on window.onunload
	function terminate(){
	    if(ws != undefined)
		ws.send("1007:");

	    clearTimeout(engineID);
	}
	
	var resizeTimeout;
	
	function OnWindowResize(e)
	{
		
	// ignore resize events as long as an actualResizeHandler execution is in the queue
	    if ( !resizeTimeout ) {
	      resizeTimeout = setTimeout(function() {
		resizeTimeout = null;
		actualResizeHandler();
	     
	       // The actualResizeHandler will execute at a rate of 15fps
	       }, 66);
	    }
	  }
	function actualResizeHandler()
	{
		if(!initialized)
			return;
		
		
		var bIsManual = ((extWidth != window.outerWidth) ||  (extHeight != window.outerHeight))
			&& (WinDevPixRatio == window.devicePixelRatio);
		
		if(bIsManual)//manual resize of the browser, otherwise it's a magnify command
		{
			resizeCanvas();
			var msg = PrepareUserDataDefinition();
			ws.send(msg);
			questionSent = true;
		}
		else
		{
			//resize the canvas following devicepixelratio
			resizeCanvasMagnify();
			var msg = PrepareUserDataDefinition();
			ws.send(msg);
			questionSent = true;
			WinDevPixRatio = window.devicePixelRatio;
		}
	}
	// END Windows lifetime
	//**************************************************************************************



	//**************************************************************************************
	// Communication functions
	var questionSent = false;
	var currRequestingScreen = "";
	var lastRequestScreen = "";
	var mmoveEn = true;
	var answer = "";
	var MonitorsScreenPoll = "-";

	var waitingForScreen = false;
	
	function ElaborateAnswer()
	{
		answer = "";
		if(MessageReceived != "")
		{
			questionSent = false;

			var message = MessageReceived.split("\t");
			MessageReceived = "";
			switch(message[0])
			{
			    case "1001":
				if(message.length > 1 && message[1]  === "1")
				{
				    answer = "1022:";
					if(startupscreen.length > 0)
						answer += startupscreen;
					MonitorsScreenPoll = "-"
				}
				else if(message.length > 1 && message[1]  === "100")
				{
					ShowModalAlert("No more licenses available on the server !\nPlease try later or contact you server administrator.");
				}
				else
				{
				    ShowPwdModal();
				}
				break;
			    case "1022":
				if(message.length > 1 && message[1] === "1")
				{
					answer = "1023:" + MonitorsScreenPoll;
					currRequestingScreen = "";
					waitingForScreen = false;
				}
				else if(message.length > 1 && message[1]  === "3")
				{
					ShowModalAlert("The requested screen was not found on the server !");
				}
				else
				{
					if(message.length > 2)
						currRequestingScreen = message[2];
					answer = "1022:" + currRequestingScreen;
					
					lastRequestScreen = currRequestingScreen;
					ctx.fillStyle = "#FFFFFF";
					ctx.fillRect(0, 0, canvasMain.width, canvasMain.height);
					waitingForScreen = true;
					$("body").css("cursor", "progress");
				}
				break;
				case "1046":
				if(message.length === 3)
				{
					if(monitorAlarmSound == 1)
					{
						startAlarmSound();
					}
					soundPlaySound = (message[2] == "1");
					answer = "";
				}
				break;
				case "1047":
				if(message.length === 3)
				{
					soundPlaySound = false;
					stopAlarmSound();
					answer = "";
				}
				break;
			    case "1023":
				
				if(message.length <= 3 || message[1] !== "210")
				{
					if (message.length === 2 && message[1] === "14") 
					{
						terminate();
						FadePage();
						if (ws != undefined)
							ws.close();
						CancelPwdModal();
						CancelInputModal();
						ShowModalAlert("Session closed by autologoff timer!");
					}
					else if(message.length >= 3 && message[1] === "6")
					{
						currRequestingScreen = message[2];
						var str = "1022:" + message[2];
						if(message.length === 4)
							str += ";" + message[3]
						answer = str;
					}
					else if(message.length === 3 && message[1] === "5")
					{
						var str = "1023:" + MonitorsScreenPoll;
						answer = str;
					}
					else if(message.length >= 3 && message[1] === "13")
					{
						var info = message[2];
						if(monitorAlarmSound == 1 && !soundStarted)
						{
							startAlarmSound();
						}
						soundPlaySound = (message[2] == "1");
						answer = "";
					}
					else if(message.length === 4 && message[1] === "11")
					{
						var values = [];
						var info = message[2];
						var isPassword = false;
						if(info.indexOf("***psw***") != -1)
							isPassword = true;
						
						for (i = 0; i < 3; i++) { 
							var pos = info.indexOf("|");
							if(pos != -1)
							{
								if(pos === 0)
								    values.push("");
								else
								    values.push(info.substr(0, pos));
								if(info.length > pos)
								    info = info.slice(pos + 1);
								else
								    info = "";
							}
							else
							{
								if(info.length > 0)
								{
									values.push(info);
									info = "";
								}
								else
									values.push("");
							}
							if(i == 2)
								values.push(info);
						}
						if(values.length > 2)
						{
							var variable = message[3];
							ShowInputValue(values[0], values[1], values[2], message[3]);
						}
					}
					
				}
				else if(message.length > 4 && message[1] === "210")
				{
					var ics = Number(message[2]);
					var ipsilon = Number(message[3]);
					
					var img = new Image();
					img.onload = function () {
						ctx.drawImage(img, ics, ipsilon, img.width, img.height);
						
					};
					img.src = message[4];
					answer = "";
					MonitorsScreenPoll = "";
					clearTimeout(engineID);
					engineID = setTimeout(CommEngine, 5);
					$("body").css("cursor", "default");
				}
				break;
			    case "1024":
				break;
			    case "1029":
				answer = "1022:" + lastRequestScreen;
				if(message.length > 1 && message[1] === "1")
					MonitorsScreenPoll = "-"
				break;
			    case "1025":
				break;
			    case "1026":
				break;
			    case "1031":
				break;
			    case "1007":
				MonitorsScreenPoll = "-"
				break;
			    default:
				break;
			}
		}
	}
	/* Sound manager */
	var soundId; 
	var soundOrder = 0;
	var soundTime = 200;
	var soundStarted = false;
	var soundPlaySound = false;
	
	var monitorAlarmSound = 0;
	
	var soundContext = new AudioContext();
	var soundOscillator = null;
	var soundGain = null;
	
	function initSoundEngine()
	{
		soundOscillator = soundContext.createOscillator();
		soundGain = soundContext.createGain();
		soundOscillator.connect(soundGain);
		soundOscillator.type = "square";
		soundGain.connect(soundContext.destination);
	}
	function startAlarmSound()
	{
		if(!soundStarted)
			soundId = setTimeout(AlarmSoundEngine, 5);
	}
	function stopAlarmSound()
	{
		clearTimeout(soundId);
		
		if(soundOscillator != null && soundStarted)
			soundOscillator.stop();
		
		soundStarted = false;
	}
	
	function AlarmSoundEngine()
	{
		if(soundPlaySound)
		{
			if(soundOscillator != null && soundStarted)
				soundOscillator.stop();

			initSoundEngine();
			
			if(soundOrder === 0)
			{
				soundOscillator.frequency.value = 1000;
				soundOrder = 1;
			}
			else
			{
				soundOscillator.frequency.value = 500;
				soundOrder = 0;
			}
			soundOscillator.start();	
			soundStarted = true;
			soundId = setTimeout(AlarmSoundEngine, soundTime);
		}
		else
		{
			if(soundOscillator != null && soundStarted)
				soundOscillator.stop()
			soundStarted = false;
		}
	}
	
	/* ------------- */
	function CommEngine()
	{
		if(!questionSent)
		{
			if(answer === "" && !questionSent)
			{
				if(msgMouseDown !== "")
				{
					answer = msgMouseDown;
					msgMouseDown = "";
					mmoveEn = true;
				}
				else if(msgMouseUp !== "")
				{
					answer = msgMouseUp;
					msgMouseUp = "";
					mmoveEn = true;
				}
				else if(msgMouseMove !== "")
				{
					mmoveEn = false;
					answer = msgMouseMove;
					msgMouseMove = "";
				}
				else
				{
					answer = "1023:" + MonitorsScreenPoll;
					mmoveEn = true;
				}
			}


			if(answer != "")
			{
				ws.send(answer);
				questionSent = true;
			}
			else
				console.log("answer vuota");
		}
		engineID = setTimeout(CommEngine, 20);
	}

	function openConnection() {
		ws = new WebSocket(url);
		ws.onmessage = onMessage;

		ws.onopen = onOpen;

		ws.onclose = function () {
			FadePage();
			soundPlaySound = false;
			stopAlarmSound();
		};
	}

	
	function FadePage(){
		ctx.globalAlpha=0.4;
		ctx.fillStyle="#A0A0A0";
		ctx.fillRect(0,0,canvasMain.width,canvasMain.height);
	}

	var extWidth = 0
	var extHeight = 0;
	
	
	function resizeCanvas() {
		extWidth = window.outerWidth;
		extHeight = window.outerHeight;
		var bodyWidth = Math.round(window.innerWidth);
		var bodyHeight = Math.round(window.innerHeight);
		
		canvasMain.clientWidth = window.innerWidth;
		canvasMain.clientHeight = window.innerHeight;
		canvasContainer.width = bodyWidth;
		canvasMain.width = bodyWidth;
		canvasContainer.height = bodyHeight;
		canvasMain.height = bodyHeight  - inOffsett;
		
		currentWindowWidth = bodyWidth;
		currentWindowHeight = bodyHeight;
		originalWindowWidth = bodyWidth;
		originalWindowHeight = bodyHeight;
		
		var bar = document.getElementById('myBar');
		bar.style.top = canvasMain.height + "px";
		bar.style.width = bodyWidth + "px";
		bar.style.height = inOffsett + "px";
		
		
		return 1;
	}

	function resizeCanvasMagnify()
	{
		
		canvasMain.clientWidth = currentWindowWidth;
		canvasMain.clientHeight = currentWindowHeight;
		var bodyWidth = Math.round(
		originalWindowWidth 
		* window.devicePixelRatio);
		var bodyHeight = Math.round(
		originalWindowHeight
		* window.devicePixelRatio);
		
		canvasMain.width =  canvasContainer.width =  bodyWidth;
		canvasContainer.height = bodyHeight;
		canvasMain.height = bodyHeight - inOffsett;
		
	}
	
	function PrepareNewValue(newVal)
	{
		return "1031:" + newVal;
	}

	function PrepareAuthentication(user, password)
	{
		var screenWidth = Math.round(canvasMain.width);
		var screenHeight = Math.round(canvasMain.height);
		var numColors = 24;
		var language = "it";
		var d = new Date();
		var GMTTimeDiff = - d.getTimezoneOffset();
		var canCallback = 0;
		var clientBuild = 1185;
		
		var msg = "1001:";
		msg += user;
		msg += sep;
		msg += password;
		msg += sep;
		msg += screenWidth;
		msg += sep;
		msg += screenHeight;
		msg += sep;
		msg += numColors;
		msg += sep;
		msg += language;
		msg += sep;
		msg += GMTTimeDiff;
		msg += sep;
		msg += canCallback;
		msg += sep;
		msg += clientBuild;
		msg += sep;
		msg += monitorAlarmSound;
		return msg;
	}

	function PrepareUserDataDefinition()
	{
		var screenWidth = Math.round(canvasMain.width);
		var screenHeight = Math.round(canvasMain.height);
		var numColors = 24;
		var language = "it";
		var d = new Date();
		var GMTTimeDiff = - d.getTimezoneOffset();
		var canCallback = 0;
		var clientBuild = 1185;
		
		var msg = "1029:";
		msg += screenWidth;
		msg += sep;
		msg += screenHeight;
		msg += sep;
		msg += numColors;
		msg += sep;
		msg += language;
		msg += sep;
		msg += GMTTimeDiff;
		msg += sep;
		msg += canCallback;
		msg += sep;
		msg += clientBuild;
		msg += sep;
		msg += monitorAlarmSound;
		return msg;
	}
	
	/*
	*   Communication Event management
	*/
	function onMessage(evt) {
		if (typeof evt !== "undefined" && typeof evt.data == "string") {
			var str = evt.data.toString();
			var idx = str.indexOf(":");
			if(idx != -1 && idx < str.length - 1)
			{
				var msgData = str.slice(idx+1);
				MessageReceived = msgData;
				ElaborateAnswer();
			}
			else
				$("#out").append("Invalid frame received!<br/>")
		}
	}

	function onOpen(evt) {

		initialized = true;

		ctx = canvasMain.getContext("2d");
		ctx.globalAlpha=1.0;
		ctx.strokeStyle = "rgba(255,0,0,1.0)";
		ctx.lineWidth = 1;
		ctx.strokeRect(0, 0, canvasMain.width, canvasMain.height);

		var user = "";
		var pwd = "";
		var msg = PrepareAuthentication(user, pwd);

		ws.send(msg);

		questionSent = true;

		if(!engineStarted)
		{
			engineStarted = true;
			engineID = setTimeout(CommEngine, 5);
		}
	}
	// END Communication functions
	//**********************************************************************
        
	function ToggleSound()
	{
		var sBtn = document.getElementById('sndButton');
		
		if(monitorAlarmSound == 1)
			{
				monitorAlarmSound = 0;
				ws.send("1047:");
				questionSent = true;
				sBtn.innerHTML = "Sound Off";
			}
			else
			{
				monitorAlarmSound = 1;
				ws.send("1046:");
				questionSent = true;
				sBtn.innerHTML = "Sound On";
			}
	}

	//**********************************************************************
	// Canvas events
        
	function oncanvasMainMouseDown(e) 
	{
		if(waitingForScreen)
			return;
		
		if (!initialized)
			return;

			
		var x = (e.offsetX !== undefined) ? e.offsetX : (e.layerX - e.target.offsetLeft);
		var y = (e.offsetY !== undefined) ? e.offsetY : (e.layerY - e.target.offsetTop);

		x -= canvasMain.offsetLeft;
		y -= canvasMain.offsetTop;

		var msg = "1025:";
		msg += Math.round(x);
		msg += sep;
		msg += Math.round(y);
		msgMouseDown = msg;
	}

	function oncanvasMainMouseUp(e) 
	{
		if(waitingForScreen)
			return;
		
		if (!initialized)
			return;

		var x = (e.offsetX !== undefined) ? e.offsetX : (e.layerX - e.target.offsetLeft);
		var y = (e.offsetY !== undefined) ? e.offsetY : (e.layerY - e.target.offsetTop);

		x -= canvasMain.offsetLeft;
		y -= canvasMain.offsetTop;

		var msg = "1026:";
		msg += Math.round(x);
		msg += sep;
		msg += Math.round(y);
		msgMouseUp = msg;
	}
	function oncanvasMainMouseMove(e) {
		if(waitingForScreen)
			return;
		
		if (!initialized )
			return;

		var x = (e.offsetX !== undefined) ? e.offsetX : (e.layerX - e.target.offsetLeft);
		var y = (e.offsetY !== undefined) ? e.offsetY : (e.layerY - e.target.offsetTop);

		x -= canvasMain.offsetLeft;
		y -= canvasMain.offsetTop;

		var msg = "1024:";
		msg += Math.round(x);
		msg += sep;
		msg += Math.round(y);
		msgMouseMove = msg;
	}
		
	// END Canvas events
	//**********************************************************************
	